#Created by George Bargoud

from sys    import argv
from time   import localtime, mktime, time, strftime, strptime
from random import randrange
from csv    import reader
from os     import path

class day:
    schedule = []
##    StartTime and endTime expected to be in a 
##    60*hour + minute format but any format which can be properly 
##    compared should work as long as you're consistent.
    
    def addCourse(self, name, startTime, endTime):
        course = (name, startTime, endTime)
        self.schedule.append(course)
    def getCourse(self,time):
        for course in self.schedule:
            startTime = course[1]
            endTime   = course[2]
            if((time >= startTime) and
               (time <= endTime  )):
                return course[0]
        return "other"
    

def getClassName(noteTime = time()):
    #schedule= [mon=0,tue=1,wed=2,thu=3,fri=4,sat=5,sun=6]
    schedule = [day(),day(),day(),day(),day(),day(),day()]

    #csv parsing
    if (path.isfile(path.abspath("schedule.csv"))):
        courses = reader(open(path.abspath("schedule.csv"),"r"))
    for c in courses:
        name = c[1]
        startHour   = int(c[2])
        startMinute = int(c[3])
        startTime   = 60*startHour + startMinute
        endHour     = int(c[4])
        endMinute   = int(c[5])
        endTime     = 60*endHour   + endMinute
        
        schedule[int(c[0])].addCourse(name,startTime,endTime)
    
    #end csv parsing
    
    timeTaken = localtime(noteTime)

    weekDay = timeTaken[6]
    hour    = timeTaken[3]
    minute  = timeTaken[4]
    time    = 60*hour + minute
    
    return schedule[weekDay].getCourse(time)
    

def tester(tests = 5):
    print "testing current time"
    getClassName()
    print ""

    for i in range(tests):
        day    = randrange(7) + 1
        hour   = randrange(24)
        minute = randrange(60)
        timestring = "2000 " + str(day) + " " + str(hour) + ":" + str(minute)
        testTime = strptime(timestring, "%Y %j %H:%M")

        print "testing " + strftime("%A %I:%M %p",testTime)
        getClassName(mktime(testTime))
        print ""



if __name__ == "__main__":
    if (len(argv) > 1):
        getClassName(float(argv[1]))
    else:
        tester()
